function imh = xwindow2D(im,method);
% imh = xhanning2D(im,n)
% Multiplies a matrix IM by a 2D Hanning window of n*n points, where n is the size of IM. Unlike the function hanning from Matlab,
% xhannig2D is not symetric.
%
% Xavier Trepat 2007.

n=size(im,1);
m=size(im,2);
switch method,
    case('hanning')   
        [xi,xj]=meshgrid(1:n,1:m);
        w = 0.25*(1-cos(2*pi*xi/n)).*(1-cos(2*pi*xj/m));
    case('cosn')
        dev=20;
        wn = (1-cos(pi*(0:n-1)/(n-1)).^dev);
        wm = (1-cos(pi*(0:m-1)/(m-1)).^dev);
        w = wn'*wm;
end

imh = im.*w';